import React, {Component} from 'react';
import PropTypes from 'prop-types';
import SpeciesList from "./SpeciesList";
import {compose} from "redux";
import {graphql} from "react-apollo";
import {authUserQuery, countMonitoraggioSpecies, monitoraggioSpeciesQuery} from "../../../../api/queries";
import {deleteMonitoraggioSpecieMutation} from "../../../../api/mutation";

export class SpeciesListContainer extends Component {

  constructor(props) {
    super(props)
  }

  render() {
    return (
      <SpeciesList {...this.props} />
    )
  }
}

export default compose(
  graphql(monitoraggioSpeciesQuery, {
    variables: {
      filtro: "",
      pagination: {
        limit: 50, offset: 0
      }
    }
  }),
  graphql(deleteMonitoraggioSpecieMutation),
  graphql(authUserQuery, {name: 'utenteSessione'})
)(SpeciesListContainer);

SpeciesListContainer.defaultProps = {};

SpeciesListContainer.propTypes = {};